% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1-glXYPlot.R
\name{glXYPlot}
\alias{glXYPlot}
\title{Glimma XY Plot}
\usage{
glXYPlot(
  x,
  y,
  counts = NULL,
  groups = NULL,
  samples = NULL,
  status = rep(0, nrow(data)),
  anno = NULL,
  display.columns = NULL,
  xlab = "x",
  ylab = "y",
  side.main = "GeneID",
  side.xlab = "Group",
  side.ylab = "Expression",
  sample.cols = rep("#1f77b4", length(groups)),
  cols = c("#00bfff", "#858585", "#ff3030"),
  jitter = 30,
  path = getwd(),
  folder = "glimma-plots",
  html = "XY-Plot",
  launch = TRUE,
  ...
)
}
\arguments{
\item{x}{a numeric vector of values to plot on the x-axis of the summary plot.}

\item{y}{a numeric vector of values to plot on the y-axis of the summary plot.}

\item{counts}{the matrix containing all counts, the column order should correspond to the order of the x and y vectors.}

\item{groups}{the factor containing experimental groups of the samples.}

\item{samples}{the names of the samples.}

\item{status}{vector giving the control status of data point, of same length as the number of rows of object. If NULL, then all points are plotted in the default colour}

\item{anno}{the data.frame containing gene annotations.}

\item{display.columns}{character vector containing names of columns to display in mouseover tooltips and table.}

\item{xlab}{the label on the x axis for the left plot.}

\item{ylab}{the label on the y axis for the left plot.}

\item{side.main}{the column containing mains for right plot.}

\item{side.xlab}{the label on the x axis for the right plot.}

\item{side.ylab}{the label on the y axis for the right plot.}

\item{sample.cols}{vector of strings denoting colours for each sample point on the expression plot.}

\item{cols}{vector of strings denoting colours corresponding to control status -1, 0 and 1. (may be R named colours or Hex values)}

\item{jitter}{the amount of jitter to apply to the samples in the expressions plot.}

\item{path}{the path in which the folder will be created.}

\item{folder}{the name of the fold to save html file to.}

\item{html}{the name of the html file to save plots to.}

\item{launch}{TRUE to launch plot after call.}

\item{...}{additional arguments to be passed onto the MD plot. (main, etc. can be set for the left plot)}
}
\value{
Draws a two-panel interactive XY scatter plot in an html page. The left plot
shows the x and y values specified. The right plot shows the
expression levels of a particular gene in each sample. Hovering over points
on left plot will plot expression level for the corresponding gene, clicking
on points will fix the expression plot to that gene. Clicking on rows on the table
has the same effect as clicking on the corresponding gene in the plot. This function
generates a display that is similar in style to glMDPlot, except that it provides more
flexibility in what the user can provide.
}
\description{
Draw an interactive XY plot with multiple panels
}
\examples{
data(iris)
\donttest{
glXYPlot(iris$Sepal.Width, iris$Sepal.Length, 
         xlab="Sepal.Width", ylab="Sepal.Length", side.main="PlantID")
}

}
\author{
Charity Law and Shian Su
}
