% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{shiftCountsOne}
\alias{shiftCountsOne}
\title{Add one to all counts in an expression matrix}
\usage{
shiftCountsOne(object, elt = "exprs", useDALogic = FALSE)
}
\arguments{
\item{object}{name of the NanoStringGeoMxSet object}

\item{elt}{expression matrix element in \code{assayDataElement}
to shift all counts by}

\item{useDALogic}{boolean to use the same logic in DA (impute 0s to 1s)
or set to FALSE to shift all counts by 1}
}
\value{
object of NanoStringGeoMxSet class
}
\description{
Add one to all counts in an expression matrix
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
shiftCountsOne(demoData)

}
