% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-aggregate.R
\name{summarizeNegatives}
\alias{summarizeNegatives}
\title{Calculate negative probe summary stats}
\usage{
summarizeNegatives(object, functionList = c())
}
\arguments{
\item{object}{name of the NanoStringGeoMxSet object to summarize}

\item{functionList}{optional list of additional functions to calculate negative 
probe stats, list element names should correspond to expected stat column header}
}
\value{
a NanoStringGeoMxSet object with negative probe summary stats 
appended to sample data
}
\description{
Calculate negative probe summary stats
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
demoData <- 
    summarizeNegatives(demoData, 
                       functionList=c(mean=mean, min=min, max=max))

}
