% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNP.R
\name{differential_SNP_GEO}
\alias{differential_SNP_GEO}
\title{Do difference analysis of SNP data downloaded from GEO}
\usage{
differential_SNP_GEO(snpData, sampleGroup, method = "Chisquare")
}
\arguments{
\item{snpData}{data.frame of SNP data downloaded from GEO}

\item{sampleGroup}{vector of sample group}

\item{method}{one of "Chisquare", "fisher",
and "CATT"(Cochran-Armitage trend test)}
}
\value{
data.frame
}
\description{
Do difference analysis of SNP data downloaded from GEO
}
\examples{
\donttest{
file1 <- read.table("GSE66903_series_matrix.txt.gz",
    fill=TRUE, comment.char="!", header = TRUE)
rownames(file1) <- file1[, 1]
snpData <- file1[, -1]
sampleGroup <- sample(c("A", "B"), ncol(snpData ), replace = TRUE)
names(sampleGroup) <- colnames(snpData)
snpData <- SNP_QC(snpData)
sampleGroup <- sample(c("A", "B"), ncol(snpData ), replace = TRUE)
result1 <- differential_SNP_GEO(snpData = snpData,
    sampleGroup = sampleGroup, method = "Chisquare")
}
# use demo data
snpDf <- matrix(sample(c("AA", "Aa", "aa"), 100, replace = TRUE), 10, 10)
snpDf <- as.data.frame(snpDf)
sampleGroup <- sample(c("A", "B"), 10, replace = TRUE)
result <- differential_SNP_GEO(snpDf, sampleGroup, method = "fisher")
}
