% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNP.R
\name{differential_SNP}
\alias{differential_SNP}
\title{Do difference analysis of SNP data}
\usage{
differential_SNP(snpDf, sampleGroup, combineMethod = min)
}
\arguments{
\item{snpDf}{data.frame of SNP data, each column is a sample, 
and each row is a SNP.}

\item{sampleGroup}{vector of sample group.}

\item{combineMethod}{Method of combining the
pvalue of multiple snp in a gene.}
}
\value{
data.frame
}
\description{
Do difference analysis of SNP data
}
\examples{
\donttest{
library(TCGAbiolinks)
query <- GDCquery(
    project = "TCGA-CHOL",
    data.category = "Simple Nucleotide Variation",
    access = "open",
    legacy = FALSE,
    data.type = "Masked Somatic Mutation",
    workflow.type = "Aliquot Ensemble Somatic Variant Merging and Masking"
)
GDCdownload(query)
data_snp <- GDCprepare(query)
samples <- unique(data_snp$Tumor_Sample_Barcode)
sampleGroup <- sample(c("A", "B"), length(samples), replace = TRUE)
names(sampleGroup) <- samples
pvalue <- differential_SNP_tcga(snpData = data_snp, 
    sampleGroup = sampleGroup)
}
# use demo data
snpDf <- matrix(sample(c("mutation", NA), 100, replace = TRUE), 10, 10)
snpDf <- as.data.frame(snpDf)
sampleGroup <- sample(c("A", "B"), 10, replace = TRUE)
result <- differential_SNP(snpDf, sampleGroup)
}
