% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNP.R
\name{SNP_QC}
\alias{SNP_QC}
\title{Do quality control of SNP data downloaded from TCGAbiolinks}
\usage{
SNP_QC(
  snpData,
  geon = 0.02,
  mind = 0.02,
  maf = 0.05,
  hwe = 1e-06,
  miss = "NoCall"
)
}
\arguments{
\item{snpData}{data.frame of SNP data downloaded from TCGAbiolinks}

\item{geon}{filters out all variants with missing call rates
exceeding the provided value (default 0.02) to be removed}

\item{mind}{filters out all samples with missing call rates exceeding
the provided value (default 0.02) to be removed}

\item{maf}{filters out all variants with minor allele frequency below
the provided threshold}

\item{hwe}{filters out all variants which have Hardy-Weinberg
equilibrium exact test p-value below the provided threshold}

\item{miss}{character of miss value}
}
\value{
data.frame
}
\description{
Do quality control of SNP data downloaded from TCGAbiolinks
}
\examples{
# use demo data
snpDf <- matrix(sample(c("AA", "Aa", "aa"), 100, replace = TRUE), 10, 10)
snpDf <- as.data.frame(snpDf)
sampleGroup <- sample(c("A", "B"), 10, replace = TRUE)
result <- SNP_QC(snpDf)
}
