% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoisBG.R
\docType{methods}
\name{fitPoisBG_sp}
\alias{fitPoisBG_sp}
\alias{fitPoisBG_sp,matrix-method}
\title{Estimate Poisson background model for multiple slides}
\usage{
fitPoisBG_sp(object, ...)

\S4method{fitPoisBG_sp}{matrix}(
  object,
  id,
  iterations = 10,
  tol = 0.001,
  size_scale = c("sum", "first")
)
}
\arguments{
\item{object}{count matrix with features in rows and samples in columns}

\item{...}{additional argument list that might be used}

\item{id}{character vector same size as sample size representing slide names of each sample}

\item{iterations}{maximum iterations to be run, default=10}

\item{tol}{tolerance to determine convergence, default = 1e-3}

\item{size_scale}{method to scale the sizefact, sum(sizefact)=1 when size_scale="sum", sizefact[1]=1 when size_scale="first"}
}
\value{
a list of following items
\itemize{
  \item sizefact - estimated size factor
  \item featfact - estimated feature factor matrix, column names the same as the slide id
  \item countmat - the input count matrix
  \item id - the input id
}
}
\description{
Estimate Poisson background model for multiple slides:
}
