% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomicSignatures-methods.R
\name{GenomicSignatures-methods}
\alias{GenomicSignatures-methods}
\alias{RAVindex}
\alias{colData}
\alias{metadata}
\alias{geneSets}
\alias{updateNote}
\alias{geneSets<-}
\alias{updateNote<-}
\alias{RAVindex,GenomicSignatures-method}
\alias{geneSets,GenomicSignatures-method}
\alias{updateNote,GenomicSignatures-method}
\alias{version,GenomicSignatures-method}
\alias{geneSets<-,GenomicSignatures-method}
\alias{updateNote<-,GenomicSignatures-method}
\title{Methods and accesors for \code{GenomicSignatures} object}
\usage{
\S4method{RAVindex}{GenomicSignatures}(x)

\S4method{geneSets}{GenomicSignatures}(x)

\S4method{updateNote}{GenomicSignatures}(x)

\S4method{version}{GenomicSignatures}(x)

\S4method{geneSets}{GenomicSignatures}(x) <- value

\S4method{updateNote}{GenomicSignatures}(x) <- value
}
\arguments{
\item{x}{A \code{GenomicSignatures} object}

\item{value}{See details.}
}
\value{
A GenomicSignatures object for the constructor
}
\description{
The default contents of \code{GenomicSignatures} object, with
a set of getter and setter generic functions, which extract either the
\code{assay}, \code{colData}, or \code{metadata} slots of a
\code{\link{GenomicSignatures-class}} object. When you create this object,
\code{colData$studies} should be populated before adding any information in
\code{trainingData} slot.
}
\details{
\itemize{
    \item assay(x) : RAVindex (= avgLoadings) containing genes x RAVs
    \item metadata(x) : Metadata associated with RAVindex building process
    \item colData(x) : Information on RAVs
}
}
\section{Setters}{

Setter method values (i.e., \code{function(x) <- value}):
\itemize{
    \item metadata<- : Assign metadata
    \item coldata<- : Assign extra information associated with RAVs
    \item geneSets<- : A character vector containing the name of gene sets
    used to annotate average loadings
    \item updateNote<- : A character vector. Describes the main feature of a
    model construction
}
}

\section{Getters}{

\itemize{
   \item RAVindex : Equivalent to \code{assays(x)$RAVindex}
   \item geneSets : Access the \code{metadata(x)$geneSets} slot
   \item updateNote : Access the \code{metadata(x)$updateNote} slot
   \item version : Access the \code{metadata(x)$version} slot
}
}

\examples{
data(miniRAVmodel)
miniRAVmodel


}
