% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HandleDataMatrix.R
\name{rank_rows}
\alias{rank_rows}
\title{Rank rows of a matrix based on user input}
\usage{
rank_rows(fullmatrix, ranking = "Hierarchical")
}
\arguments{
\item{fullmatrix}{a numeric matrix}

\item{ranking}{a string in c("Sum", "Max", "Hierarchical", "None")}
}
\value{
a numeric matrix
}
\description{
The rows of a input numeric matrix is ordered based row sum,
row maximum, or hierarchical clustering of the rows with euclidean distance
and centroid linkage. This a helper function for drawing matrix heatmaps.
}
\examples{

fullMatrix <- matrix(rnorm(100), ncol = 10)
for (i in 5:8) {
    fullMatrix[i, 4:7] <- runif(4) + i
}
apply(fullMatrix, 1, sum)
ranked <- rank_rows(fullMatrix, ranking = "Sum")
apply(ranked, 1, sum)

}
\author{
Shuye Pu
}
