% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomicPlot.R
\name{plot_overlap_bed}
\alias{plot_overlap_bed}
\title{Plot Venn diagrams depicting overlap of genomic regions}
\usage{
plot_overlap_bed(
  bedList,
  outPrefix = NULL,
  importParams = NULL,
  pairOnly = TRUE,
  stranded = TRUE,
  hw = c(8, 8),
  verbose = FALSE
)
}
\arguments{
\item{bedList}{a named list of bed files, with list length = 2, 3 or 4}

\item{outPrefix}{a string for plot file name}

\item{importParams}{a list of parameters for \code{handle_input}}

\item{pairOnly}{logical, indicating whether only pair-wise overlap is
desirable}

\item{stranded}{logical, indicating whether the feature is stranded. For
nonstranded feature, only "*" is accepted as strand}

\item{hw}{a vector of two elements specifying the height and width of the
output figures}

\item{verbose}{logical, indicating whether to output additional information}
}
\value{
a ggplot object
}
\description{
This function takes a list of up to 4 bed file names, and
produce a Venn diagram
}
\examples{

queryFiles <- c(
    system.file("extdata", "test_chip_peak_chr19.narrowPeak",
        package = "GenomicPlot"
    ),
    system.file("extdata", "test_chip_peak_chr19.bed",
        package = "GenomicPlot"
    ),
    system.file("extdata", "test_clip_peak_chr19.bed",
        package = "GenomicPlot"
    )
)
names(queryFiles) <- c("narrowPeak", "summitPeak", "clipPeak")

bedimportParams <- setImportParams(
    offset = 0, fix_width = 100, fix_point = "center", norm = FALSE,
    useScore = FALSE, outRle = FALSE, useSizeFactor = FALSE, genome = "hg19"
)

plot_overlap_bed(
    bedList = queryFiles, importParams = bedimportParams, pairOnly = FALSE,
    stranded = FALSE, outPrefix = NULL
)

}
\author{
Shuye Pu
}
