% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition-plots.R
\name{calcCumulativePartitionsRef}
\alias{calcCumulativePartitionsRef}
\title{Calculates the cumulative distribution of overlaps for a query set to a
reference assembly}
\usage{
calcCumulativePartitionsRef(query, refAssembly)
}
\arguments{
\item{query}{A GenomicRanges or GenomicRangesList object with query regions}

\item{refAssembly}{A character vector specifying the reference genome
assembly (*e.g.* 'hg19'). This will be used to grab chromosome sizes
with \code{getTSSs}.}
}
\value{
A data.frame indicating the number of query region overlaps in
    several genomic partitions.
}
\description{
This function is a wrapper for \code{calcCumulativePartitions} that uses
built-in partitions for a given reference genome assembly.
}
\examples{
calcCumulativePartitionsRef(vistaEnhancers, "hg19")
}
