% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeq.R
\name{modeq}
\alias{modeq}
\title{A Wrapper Calling Modular Linear Equation Solver (MLE)}
\usage{
modeq(a, b, n)
}
\value{
A number. If the equation has not solution in their definition,
domain it will return -1.
}
\description{
It is just a wrapper function to call
\code{\link[numbers]{modlin}}. This function is intended to be use
internally. MLE (\eqn{a * x = b mod n}) not always has solution If the MLE
has not solution the function will return the value -1. Also, if
\eqn{a * x = b mod n} has solution x = 0, then function \emph{'modeq'}
will return -1.
}
\examples{
## The MLE 10 * x = 3 mod 64 has not solution
modeq(10, 3, 64)

## The result is the giving calling modlin(10, 4, 64)
modeq(10, 4, 64)
}
\keyword{internal}
