% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod.R
\name{mod}
\alias{mod}
\alias{'\%\%'}
\alias{modulo}
\alias{mod,matrix,numeric-method}
\title{Modulo Operation}
\usage{
mod(n, m, ...)

\S4method{mod}{matrix,numeric}(n, m)
}
\arguments{
\item{n}{A numeric vector (preferably of integers), a matrix where each
element can be reduced to integers.}

\item{m}{An integer vector (positive, zero, or negative).}

\item{...}{Not in use.}
}
\value{
An element of x, an \code{\link{Automorphism-class}} object.
}
\description{
Integer remainder of the division of the integer n by m:
n mod m.
}
\examples{
## Example 1
## Build a matrix 'n' and set a vector of integers 'm'
n <- diag(x=1, nrow = 4, ncol = 4) * c(43,125,2,112)
m <- c(64,4,4,64)

## Operation n mod m 
mod(n = n, m = m)

## Or simply:
n \%\% m

## Example 2
m <- matrix(c(8,2,3, 11,12,13), nrow = 2)
m

m \%\% 4

}
\author{
Robersy Sanchez (\url{https://genomaths.com}).
}
