% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aminoacid_dist.R
\name{aminoacid_dist}
\alias{aminoacid_dist}
\alias{aminoacid_dist,character,character-method}
\alias{aminoacid_dist,DNAStringSet,ANY-method}
\alias{aminoacid_dist,AAStringSet,ANY-method}
\alias{aminoacid_dist,CodonGroup_OR_Automorphisms,ANY-method}
\title{Distance Between Aminoacids in Terms of Codon Distance}
\usage{
aminoacid_dist(aa1, aa2, ...)

\S4method{aminoacid_dist}{character,character}(
  aa1,
  aa2,
  weight = NULL,
  stat = c("mean", "median", "user_def"),
  genetic_code = "1",
  group = c("Z4", "Z5"),
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  num.cores = 1L,
  tasks = 0L,
  verbose = FALSE
)

\S4method{aminoacid_dist}{DNAStringSet,ANY}(
  aa1,
  weight = NULL,
  stat = c("mean", "median", "user_def"),
  group = c("Z4", "Z5"),
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  num.cores = 1L,
  tasks = 0L,
  verbose = FALSE
)

\S4method{aminoacid_dist}{AAStringSet,ANY}(
  aa1,
  weight = NULL,
  stat = c("mean", "median", "user_def"),
  group = c("Z4", "Z5"),
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  num.cores = 1L,
  tasks = 0L,
  verbose = FALSE
)

\S4method{aminoacid_dist}{CodonGroup_OR_Automorphisms,ANY}(
  aa1,
  weight = NULL,
  stat = c("mean", "median", "user_def"),
  group = c("Z4", "Z5"),
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  num.cores = 1L,
  tasks = 0L,
  verbose = FALSE
)
}
\arguments{
\item{aa1, aa2}{A character string of codon sequences, i.e., sequences of
DNA base-triplets. If only 'x' argument is given, then it must be a
\code{\link[Biostrings]{DNAStringSet-class}} object.}

\item{...}{Not in use yet.}

\item{weight}{A numerical vector of  weights to compute weighted Manhattan
distance between codons. If \eqn{weight = NULL}, then
\eqn{weight = (1/4,1,1/16)} for \eqn{group = "Z4"} and
\eqn{weight = (1/5,1,1/25)} for \eqn{group = "Z5"} (see
\code{\link{codon_dist}}).}

\item{stat}{The name of some statistical function summarizing data like
'mean', 'median', or some user defined function ('user_def'). If
\eqn{stat = 'user_def'}, then function must have a logical argument named
'na.rm' addressed to remove missing (NA) data (see e.g.,
\code{\link[base]{mean}}).}

\item{genetic_code}{A single string that uniquely identifies the genetic
code to extract. Should be one of the values in the id or name2 columns of
\code{\link[Biostrings]{GENETIC_CODE_TABLE}}.}

\item{group}{A character string denoting the group representation for the
given codon sequence as shown in reference (2-3).}

\item{cube}{A character string denoting one of the 24 Genetic-code cubes,
as given in references (2-3).}

\item{num.cores, tasks}{Parameters for parallel computation using package
\code{\link[BiocParallel]{BiocParallel-package}}: the number of cores to
use, i.e. at most how many child processes will be run simultaneously (see
\code{\link[BiocParallel]{bplapply}} and the number of tasks per job (only
for Linux OS).}

\item{verbose}{If TRUE, prints the progress bar.}
}
\value{
A numerical vector with the pairwise distances between codons in
sequences 'x' and 'y'.
}
\description{
This function computes the distance between aminoacids in
terms of a statistic of the corresponding codons. The possible statistics
are: 'mean', 'median', or some user defined function.
}
\details{
Only aminoacids sequences given in the following alphabet are
accepted: "A","R","N","D","C","Q","E","G","H","I","L","K", "M","F","P",
"S","T","W","Y","V", "\emph{", "-", and "X"; where symbols "}" and "-" denote
the presence a stop codon and of a gap, respectively, and letter "X"
missing information, which are then taken as a gap.

The distance between any aminoacid and any of the non-aminoacid symbols is
the ceiling of the greater distance found in the corresponding aminoacid
distance matrix.
}
\examples{
## Write down to aminoacid sequences
x <- "A*LTHMC"
y <- "AAMTDM-"

aminoacid_dist(aa1 = x, aa2 = y)

## Let's create an AAStringSet-class object
aa <- AAStringSet(c(x, y))

aminoacid_dist(aa1 = aa)

## Let's select cube "GCAT" and group "Z5"
aminoacid_dist(aa1 = aa, group = "Z5", cube = "TCGA")

}
\references{
\enumerate{
\item Sanchez R. Evolutionary Analysis of DNA-Protein-Coding Regions Based
on a Genetic Code Cube Metric. Curr. Top. Med. Chem. 2014;14: 407–417.
\url{https://doi.org/10.2174/1568026613666131204110022}.
\item M. V Jose, E.R. Morgado, R. Sanchez, T. Govezensky, The 24 possible
algebraic representations of the standard genetic code in six or in three
dimensions, Adv. Stud. Biol. 4 (2012) 119-152.\href{https://is.gd/na9eap}{PDF}.
\item R. Sanchez. Symmetric Group of the Genetic-Code Cubes. Effect of the
Genetic-Code Architecture on the Evolutionary Process MATCH Commun. Math.
Comput. Chem. 79 (2018) 527-560. \href{https://is.gd/ZY1Gx8}{PDF}.
}
}
\seealso{
\code{\link{automorphisms}} and \code{\link{codon_coord}}

\code{\link{codon_dist}}
}
