% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntronRetention.R
\name{findIntronContainingTranscripts}
\alias{findIntronContainingTranscripts}
\title{Given the location of a whole retained intron, find transcripts which splice out this intron}
\usage{
findIntronContainingTranscripts(input, exons, match = "exact")
}
\arguments{
\item{input}{whippetDataSet generated from \code{readWhippetDataSet()} or a Granges of intron coordinates}

\item{exons}{GRanges object made from a GTF with ONLY exon annotations
(no gene, transcript, CDS etc.)}

\item{match}{what type of matching to perform? exact = only exons which bound the intron exactly,
introns = any exon pairs which overlap the intron,
all = any exon pairs AND single exons which overlap the intron}
}
\value{
data.frame with all flanking exon pairs
}
\description{
Given the location of a whole retained intron, find transcripts which splice out this intron
}
\examples{
whippetFiles <- system.file("extdata","whippet/",
package = "GeneStructureTools")
wds <- readWhippetDataSet(whippetFiles)
wds <- filterWhippetEvents(wds)

gtf <- rtracklayer::import(system.file("extdata","example_gtf.gtf",
package = "GeneStructureTools"))
exons <- gtf[gtf$type=="exon"]
g <- BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10

wds.intronRetention <- filterWhippetEvents(wds, eventTypes="RI")
exons.intronRetention <- findIntronContainingTranscripts(input=wds.intronRetention, exons)

exonsFromGRanges <- exons[exons$transcript_id=="ENSMUST00000139129.8" &
exons$exon_number \%in\% c(3,4)]
intronFromGRanges <- exonsFromGRanges[1]
GenomicRanges::start(intronFromGRanges) <-
GenomicRanges::end(exonsFromGRanges[exonsFromGRanges$exon_number==3])
GenomicRanges::end(intronFromGRanges) <-
GenomicRanges::start(exonsFromGRanges[exonsFromGRanges$exon_number==4])
exons.intronRetention <- findIntronContainingTranscripts(intronFromGRanges, exons)
}
\seealso{
Other whippet splicing isoform creation: \code{\link{addIntronInTranscript}},
  \code{\link{findExonContainingTranscripts}},
  \code{\link{findJunctionPairs}},
  \code{\link{replaceJunction}},
  \code{\link{skipExonInTranscript}}
}
\author{
Beth Signal
}
