% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CopyNumberBreakPointGenes-class}
\alias{CopyNumberBreakPointGenes}
\alias{CopyNumberBreakPointGenes-class}
\title{An S4 class to represent a CopyNumberBreakPointGenes object}
\description{
An S4 class to represent a CopyNumberBreakPointGenes object
}
\section{Slots}{

\describe{
\item{\code{geneAnnotation}}{A data.frame with original gene annotation input}

\item{\code{geneData}}{A data.frame with gene information added by package methods}

\item{\code{featuresPerGene}}{A list with the associated features per gene}

\item{\code{breakpointsPerGene}}{A matrix with breakage status per gene}
}}
\section{Accessors}{

\itemize{
   \item \code{callData( object )} Returns feature call values:
   \item \code{segmentData( object )} Returns feature segment values
   \item \code{breakpointData( object )} Returns feature breakpoint values
   \item \code{sampleNames( object )} Returns vector with sample names
   \item \code{namesFeatures( object )} Returns vector with feature names
   \item \code{featureChromosomes( object )} Returns vector of feature chromosomes
   \item \code{featureInfo( object )} Returns feature data/information
   \item \code{geneChromosomes( object )} Returns vector of gene chromosomes
   \item \code{geneInfo( object )} Returns gene data/information
   \item \code{featuresPerGene( object )} Returns a list of genes with coupled features
   \item \code{breakpointsPerGene( object )} Returns gene break status
   \item \code{recurrentGenes( object )} Returns recurrently broken genes
}
}

\section{Methods}{

\itemize{
   \item getBreakpoints Builds the \linkS4class{CopyNumberBreakPoints} object from copynumber data and detects breakpoint locations
   \item bpFilter Selects breakpoints by filter criteria options
   \item addGeneAnnotation Maps features to gene locations
   \item bpGenes Indentifies genes affected by breakpoint locations
   \item bpStats Applies cohort-based statistics to identify genes and/or chromosomal locations that are recurrently affected by breakpoints
   \item bpPlot Plots breakpoint frequencies per chromosome
}
}
\examples{
data( copynumber.data.chr20 )
data( ens.gene.ann.hg18 )
bp <- getBreakpoints( copynumber.data.chr20 )
bp <- bpFilter( bp )
bp <- addGeneAnnotation( bp, ens.gene.ann.hg18 )
bp <- bpGenes( bp )
bp <- bpStats( bp )
bpPlot( bp, c(20) )
}
\author{
E. van den Broek and S. van Lieshout
}

