% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lohView.R
\name{lohView}
\alias{lohView}
\title{Construct LOH chromosome plot}
\usage{
lohView(
  x,
  y = NULL,
  genome = "hg19",
  chr = "chr1",
  ideogram_txtAngle = 45,
  ideogram_txtSize = 5,
  plotLayer = NULL,
  ideogramLayer = NULL,
  out = "plot"
)
}
\arguments{
\item{x}{object of class data frame with rows representing Heterozygous
Germline calls. The data frame must contain columns with the following names 
"chromosome", "position", "n_vaf", "t_vaf", "sample".}

\item{y}{Object of class data frame with rows representing cytogenetic bands
for a chromosome. The data frame must contain columns with the following
names "chrom", "chromStart", "chromEnd", "name", "gieStain" for plotting the
ideogram (optional: see details).}

\item{genome}{Character string specifying a valid UCSC genome (see details).}

\item{chr}{Character string specifying which chromosome to plot one of
"chr..." or "all"}

\item{ideogram_txtAngle}{Integer specifying the angle of cytogenetic labels
on the ideogram subplot.}

\item{ideogram_txtSize}{Integer specifying the size of cytogenetic labels on
the ideogram subplot.}

\item{plotLayer}{Valid ggplot2 layer to be added to the copy number plot.}

\item{ideogramLayer}{Valid ggplot2 layer to be added to the ideogram
sub-plot.}

\item{out}{Character vector specifying the the object to output, one of
"data", "grob", or "plot", defaults to "plot" (see returns).}
}
\value{
One of the following, a list of dataframes containing data to be
plotted, a grob object, or a plot.
}
\description{
Given a data frame construct a plot to display Loss of Heterozygosity for
specific chromosomes.
}
\details{
lohView is able to plot in two modes specified via the `chr`
parameter, these modes are single chromosome view in which an ideogram is
displayed and genome view where chromosomes are faceted. For the single
chromosome view cytogenetic band information is required giving the
coordinate, stain, and name of each band. As a convenience GenVisR stores
this information for the following genomes "hg19", "hg38", "mm9", "mm10", and
"rn5". If the genome assembly supplied to the `genome` parameter is not one
of the 5 afore mentioned genome assemblies GenVisR will attempt to query the
UCSC MySQL database to retrieve this information. Alternatively the user can
manually supply this information as a data frame to the `y` parameter, input
to the `y` parameter take precedence of input to `genome`.

A word of caution, users are advised to only use heterozygous germline calls
in input to `x`, failure to do so may result in a misleading visual!
}
\examples{
# Plot loh for chromosome 5
lohView(HCC1395_Germline, chr='chr5', genome='hg19', ideogram_txtSize=4)
}
