% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnFreq.R
\name{cnFreq}
\alias{cnFreq}
\title{Construct copy-number frequency plot}
\usage{
cnFreq(
  x,
  CN_low_cutoff = 1.5,
  CN_high_cutoff = 2.5,
  plot_title = NULL,
  CN_Loss_colour = "#002EB8",
  CN_Gain_colour = "#A30000",
  x_title_size = 12,
  y_title_size = 12,
  facet_lab_size = 10,
  plotLayer = NULL,
  plotType = "proportion",
  genome = "hg19",
  plotChr = NULL,
  out = "plot"
)
}
\arguments{
\item{x}{Object of class data frame with rows representing genomic segments.
The data frame must contain columns with the following names "chromosome",
"start", "end", "segmean", and "sample". Coordinates should be 1-based space.}

\item{CN_low_cutoff}{Numeric value representing the point at or below which
copy number alterations are considered losses. Only used if x represents CN
values.}

\item{CN_high_cutoff}{Numeric value representing the point at or above which
copy number alterations are considered gains. Only used if x represents CN
values.}

\item{plot_title}{Character string specifying the title to display on the
plot.}

\item{CN_Loss_colour}{Character string specifying the colour value for copy
number losses.}

\item{CN_Gain_colour}{Character string specifying the colour value for copy
number gains.}

\item{x_title_size}{Integer specifying the size of the x-axis title.}

\item{y_title_size}{Integer specifying the size of the y-axis title.}

\item{facet_lab_size}{Integer specifying the size of the faceted labels
plotted.}

\item{plotLayer}{Valid ggplot2 layer to be added to the plot.}

\item{plotType}{Character string specifying the type of values to plot. 
One of "proportion" or "frequency"}

\item{genome}{Character string specifying a valid UCSC genome (see details).}

\item{plotChr}{Character vector specifying specific chromosomes to plot,
if NULL all chromosomes for the genome selected are displayed.}

\item{out}{Character vector specifying the the object to output, one of
"data", "grob", or "plot", defaults to "plot" (see returns).}
}
\value{
One of the following, a dataframe containing data to be
plotted, a grob object, or a plot.
}
\description{
Given a data frame construct a plot to display copy number changes across the
genome for a group of samples.
}
\details{
cnFreq requires the location of chromosome boundaries for a given
genome assembly in order to ensure the entire chromosome space is plotted.
As a convenience this information is available to cnSpec for
the following genomes "hg19", "hg38", "mm9", "mm10", "rn5" and can be
retrieved by supplying one of the afore mentioned assemblies via the `genome`
parameter. If a genome assembly is supplied to the `genome` parameter and is
unrecognized cnSpec will attempt to query the UCSC MySQL database for the
required information. If genomic segments are not identical across all samples
the algorithm will attempt to perform a disjoin operation
splitting existing segments such that there are no overlaps. The `plotLayer`
parameter can be used to add an additional layer to the ggplot2 graphic
(see vignette).
}
\examples{
# plot on internal GenVisR dataset
cnFreq(LucCNseg)
}
