% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lolliplot-class.R
\name{Lolliplot-class}
\alias{Lolliplot-class}
\alias{Lolliplot}
\title{Class Lolliplot}
\usage{
Lolliplot(
  input,
  transcript = NULL,
  species = "hsapiens",
  host = "https://www.ensembl.org",
  txdb = NULL,
  BSgenome = NULL,
  emphasize = NULL,
  DomainPalette = NULL,
  MutationPalette = NULL,
  labelAA = TRUE,
  plotALayers = NULL,
  plotBLayers = NULL,
  sectionHeights = NULL,
  verbose = FALSE
)
}
\arguments{
\item{input}{Object of class MutationAnnotationFormat, GMS, VEP, or a data.table with appropriate columns}

\item{transcript}{Character string specifying the ensembl transcript for which to plot, should be a transcript which corresponds
to the gene parameter.}

\item{species}{Character string specifying a species when using biomaRt queries}

\item{host}{Character string specifying a host to connect to when using biomaRt queries}

\item{txdb}{A bioconoductor txdb object to annotate amino acid positions, required only if amino acid changes are missing (see details).}

\item{BSgenome}{A bioconductor BSgenome object to annotate amino acid positions, required only if amino acid changes are missing (see details).}

\item{emphasize}{Character vector specifying a list of mutations to emphasize.}

\item{DomainPalette}{Character vector specifying the colors used for encoding protein domains}

\item{MutationPalette}{Character vector specifying the colors used for encoding mutations}

\item{labelAA}{Boolean specifying if labels should be added to emphasized mutations}

\item{plotALayers}{list of ggplot2 layers to be passed to the density plot.}

\item{plotBLayers}{list of ggplot2 layers to be passed to the lolliplot.}

\item{sectionHeights}{Numeric vector specifying relative heights of each plot section,
should sum to one. Expects a value for each section.}

\item{verbose}{Boolean specifying if status messages should be reported.}
}
\description{
An S4 class for the lolliplot object, under development!!!
}
\section{Slots}{

\describe{
\item{\code{PlotA}}{gtable object for the top sub-plot}

\item{\code{PlotB}}{gtable object for the bottom sub-plot}

\item{\code{Grob}}{gtable object storing the arranged plot}

\item{\code{primaryData}}{data.table object storing the primary data}

\item{\code{geneData}}{data.table object storing gene and domain coordinates}
}}

\examples{
# Load a pre-existing data set
dataset <- PIK3CA

# mode 1, amino acid changes are not present

library(TxDb.Hsapiens.UCSC.hg38.knownGene)
library(BSgenome.Hsapiens.UCSC.hg38)
txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene
BSgenome <- BSgenome.Hsapiens.UCSC.hg38

keep <- c("Chromosome", "Start_Position", "End_Position", "Reference_Allele",
          "Tumor_Seq_Allele2", "Tumor_Sample_Barcode", "Gene", "Variant_Classification")
dataset.mode1 <- dataset[,keep]
colnames(dataset.mode1) <- c("chromosome", "start", "stop", "reference", "variant",
                             "sample", "gene", "consequence")


# mode 2, amino acid changes are present

keep <- c("Chromosome", "Start_Position", "End_Position", "Reference_Allele",
          "Tumor_Seq_Allele2", "Tumor_Sample_Barcode", "Gene", "Variant_Classification",
          "Transcript_ID", "HGVSp")
dataset.mode2 <- dataset[,keep]
colnames(dataset.mode2) <- c("chromosome", "start", "stop", "reference", "variant",
                             "sample", "gene", "consequence", "transcript", "proteinCoord")

# Not Run: Generate Lolliplot
#object <- Lolliplot(dataset.mode1, transcript="ENST00000263967",
#                    species="hsapiens", txdb=txdb, BSgenome=BSgenome)
#object <- Lolliplot(dataset.mode2, transcript="ENST00000263967",
#                    species="hsapiens")
#drawPlot(object)

}
