% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_PPI.R
\name{getPPI}
\alias{getPPI}
\title{Download Protein-Protein Interaction (PPI)}
\usage{
getPPI(genes, stringdb, anno_df)
}
\arguments{
\item{genes}{a \code{list}, A \code{list} of genes to download the respective protein-
protein interaction information}

\item{stringdb}{A \code{STRINGdb} object, the species of the object should match
the species of \code{genes}.}

\item{anno_df}{An annotation \code{data.frame} mapping \code{STRINGdb} ids to gene
names, e.g. downloaded with \code{GeDi::getAnnotation()}}
}
\value{
A \code{data.frame} of Protein-Protein interactions
}
\description{
Download the Protein-Protein Interaction (PPI) information of a \code{STRINGdb}
object
}
\examples{
## Mock example showing how the data should look like

genes <- c(c("CFTR", "RALA"), c("CACNG3", "ITGA3"), c("DVL2"))
stringdb <- getStringDB(9606, cache_location = FALSE)
# stringdb
anno_df <- getAnnotation(stringdb)
ppi <- getPPI(genes, stringdb, anno_df)

## Example using the data available in the package
\dontrun{
data(macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
stringdb <- getStringDB(9606)
stringdb
anno_df <- getAnnotation(stringdb)
genes <- GeDi::prepareGenesetData(macrophage_topGO_example_small)
ppi <- getPPI(genes, stringdb, anno_df)
}
}
