% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_dendro.R
\name{distanceDendro}
\alias{distanceDendro}
\title{Plot a dendrogram}
\usage{
distanceDendro(distance_scores, cluster_method = "average")
}
\arguments{
\item{distance_scores}{A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} containing (distance) scores
between 0 and 1.}

\item{cluster_method}{character, indicating the clustering method
for the \code{\link[stats:hclust]{stats::hclust()}} function. See the
\code{\link[stats:hclust]{stats::hclust()}} function for the available options.
Defaults to 'average'.}
}
\value{
A \code{\link[ggdendro:ggdendrogram]{ggdendro::ggdendrogram()}} plot object.
}
\description{
Plot a dendrogram of a matrix of (distance) scores.
}
\examples{

## Mock example showing how the data should look like

distance_scores <- Matrix::Matrix(0.5, 20, 20)
distance_scores[c(11:15), c(2:6)] <- 0.2
dendro <- distanceDendro(distance_scores, cluster_method = "single")

## Example using the data available in the package
data(scores_macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
dendro <- distanceDendro(scores_macrophage_topGO_example_small,
                        cluster_method = "average")
}
