% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_network}
\alias{is_network}
\title{Determine if an object is a network}
\usage{
is_network(network)
}
\arguments{
\item{network}{matrix or data.frame, object to test to be a network}
}
\value{
list, a boolean as first element and in second element NULL or the
reason why boolean is set to FALSE
}
\description{
Check content of a given object to determine if it's a network, meaning a
squared matrix of similarity score between genes.
}
\examples{
net <- matrix(runif(40*40), 40)
colnames(net) <- paste0("gene_", seq_len(ncol(net)))
rownames(net) <- paste0("gene_", seq_len(nrow(net)))
is_network(net)

}
