% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_data_expr}
\alias{is_data_expr}
\title{Determine if an object is a data_expr in sens of GWENA}
\usage{
is_data_expr(data_expr)
}
\arguments{
\item{data_expr}{matrix or data.frame, expression data with genes as column
and samples as row.}
}
\value{
list, a boolean as first element and in second element NULL or the
reason why boolean is set to FALSE
}
\description{
Check an object to be a data.frame or a matrix compatible of genes and
samples.
}
\examples{
expr <- matrix(runif(15*40), 15)
colnames(expr) <- paste0("gene_", seq_len(ncol(expr)))
rownames(expr) <- paste0("gene_", seq_len(nrow(expr)))
is_data_expr(expr)

}
