% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology.R
\name{get_hub_genes}
\alias{get_hub_genes}
\title{Determine hub genes inside each module}
\usage{
get_hub_genes(
  network,
  modules = NULL,
  method = c("highest connectivity", "superior degree", "Kleinberg's score")
)
}
\arguments{
\item{network}{matrix or data.frame, square table representing connectivity
between each genes as returned by build_net. Can be whole network or a
single module.}

\item{modules}{list, modules defined as list of gene vectors. If null,
network is supposed to be the whole network or an already split module}

\item{method}{string, name of the method to be used for hub gene detection.
See details.}
}
\value{
A list of vectors representing hub genes, by module
}
\description{
Return genes considered as hub genes inside each module of a network
following the selected method. Method will be lauched with default
parameters. If specific parameters desired, please use directly the
function \code{get_hub_...} itself.
}
\details{
\describe{
  \item{highest connectivity}{Select the top n (n depending on
  parameter given) highest connected genes. Similar to
  WGCNA::chooseTopHubInEachModule.}
  \item{superior degree}{Select genes which degree is greater than average
  connection degree of the network. Definition from network theory.}
  \item{Kleinberg's score}{Select genes which Kleinberg's score superior to
  provided threshold.}
}
}
\examples{
mat <- matrix(runif(40*40), 40)
colnames(mat) <- paste0("gene_", seq_len(ncol(mat)))
rownames(mat) <- paste0("gene_", seq_len(nrow(mat)))
get_hub_genes(mat)

}
