% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-functions.R
\name{to_list}
\alias{to_list}
\title{Convert galgo.Obj to list}
\usage{
to_list(output)
}
\arguments{
\item{output}{An object of class \code{galgo.Obj}}
}
\value{
The current function restructurates a \code{galgo.Obj} to a more 
easy to understand an use \code{list}. This output is particularly useful 
if one wants to select a given solution and use its outputs in a new 
classifier. The output of type \code{list} has a length equals to the 
number of solutions obtained by the \code{\link[GSgalgoR:galgo]{galgo}} 
algorithm.

Basically this output is a list of lists, where each element of the output 
is named after the solution's name (\code{solution.n}, where \code{n} is 
the number assigned to that solution), and inside of it, it has all the 
constituents for that given solution with the following structure:
\enumerate{
\item \strong{output$solution.n$Genes}: A vector of the features included 
in the solution
\item \strong{output$solution.n$k}: The number of partitions found in that 
solution
\item \strong{output$solution.n$SC.Fit}: The average silhouette coefficient 
of the partitions found
\item \strong{output$solution.n$Surv.Fit}: The survival fitness value
\item \strong{output$solution.n$Rank}: The solution rank
\item \strong{CrowD}: The solution crowding distance related to the rest 
of the solutions
}
}
\description{
The current function transforms a \code{galgo.Obj} to a \code{list}
}
\examples{
# load example dataset
library(breastCancerTRANSBIG)
data(transbig)
Train <- transbig
rm(transbig)

expression <- Biobase::exprs(Train)
clinical <- Biobase::pData(Train)
OS <- survival::Surv(time = clinical$t.rfs, event = clinical$e.rfs)

# We will use a reduced dataset for the example
expression <- expression[sample(1:nrow(expression), 100), ]

# Now we scale the expression matrix
expression <- t(scale(t(expression)))

# Run galgo
output <- GSgalgoR::galgo(generations = 5, population = 15, 
prob_matrix = expression, OS = OS)
outputDF <- to_dataframe(output)
outputList <- to_list(output)
}
\author{
Martin E Guerrero-Gimenez, \email{mguerrero@mendoza-conicet.gob.ar}
}
