% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galgo.R
\docType{package}
\name{GSgalgoR-package}
\alias{GSgalgoR-package}
\alias{GSgalgoR}
\title{GSgalgoR:  A bi-objective evolutionary meta-heuristic to identify
robust transcriptomic classifiers associated with patient outcome across
multiple cancer types.}
\description{
This package was developed to provide a simple to use set of
functions to use the galgo algorithm. A multi-objective optimization
algorithm for disease subtype discovery based on a non-dominated sorting
genetic algorithm.

Different statistical and machine learning approaches have long been
used to identify gene expression/molecular signatures with prognostic
potential in different cancer types. Nonetheless, the molecular
classification of tumors is a difficult task and the results obtained
via the current statistical methods are highly dependent on the features
analyzed, the number of possible tumor subtypes under consideration, and
the underlying assumptions made about the data. In addition, some cancer
types are still lacking prognostic signatures and/or of subtype-specific
predictors which are continually needed to further dissect tumor biology.
In order to identify specific molecular phenotypes to develop precision
medicine strategies we present Galgo: A multi-objective optimization
process based on a non-dominated sorting genetic algorithm that combines
the advantages of clustering methods for grouping heterogeneous omics data
and the exploratory properties of genetic algorithms (GA) in order to find
features that maximize the survival difference between subtypes while
keeping high cluster consistency.

\tabular{ll}{ Package: \tab GSgalgoR\cr Type: \tab Package\cr
Version: \tab 1.0.0\cr Date: \tab 2020-05-06 \cr License: \tab GPL-3\cr
Copyright: \tab (c) 2020 Martin E. Guerrero-Gimenez.\cr URL: \tab
\url{https://www.github.com/harpomaxx/galgo}\cr LazyLoad: \tab yes\cr
}
}
\author{
Martin E. Guerrero-Gimenez \email{mguerrero@mendoza-conicet.gob.ar}

Maintainer: Carlos A. Catania \email{harpomaxx@gmail.com }
}
