% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRaccessors.R
\name{GRgetValues}
\alias{GRgetValues}
\title{GR values}
\usage{
GRgetValues(fitData)
}
\arguments{
\item{fitData}{a SummarizedExperiment object, generated by the GRfit 
function.}
}
\value{
A table with GR values and relative cell counts
}
\description{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function returns a table of the original data (in the form of 
"Case A") with columns for GR values and relative cell counts.
}
\details{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function returns a table of the original data (in the form of 
"Case A") with columns for GR values and relative cell counts. This is 
simply a convenient accessor function, equivalent to 
\code{as.data.frame(metadata(fitData)[[1]])}.
}
\examples{
# Load Case A (example 1) input
data("inputCaseA")
head(inputCaseA)
# Run GRfit function with case = "A"
output1 = GRfit(inputData = inputCaseA,
groupingVariables = c('cell_line','agent'))
GRvalues = GRgetValues(output1)
head(GRvalues)
\dontrun{View(GRvalues)}
}
\seealso{
To create the object needed for this function, see
\code{\link{GRfit}}.
}
\author{
Nicholas Clark
}
