% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEM_GUI.R
\docType{package}
\name{GEM-package}
\alias{GEM-package}
\title{GEM: Fast association study for the interplay of Gene, Environment and Methylation}
\description{
The GEM package provides a highly efficient R tool suite for performing epigenome wide association
studies (EWAS). GEM provides three major functions named \code{\link{GEM_Emodel}},
\code{\link{GEM_Gmodel}} and \code{\link{GEM_GxEmodel}} to study the interplay of Gene,
Environment and Methylation (GEM). Within GEM, the existing "Matrix eQTL" package is
utilized and extended to study methylation quantitative trait loci (methQTL) and the
interaction of genotype and environment (GxE) to determine DNA methylation variation,
using matrix based iterative correlation and memory-efficient data analysis.
GEM can facilitate reliable genome-wide methQTL and GxE analysis on a standard laptop
computer within minutes.
}
\examples{

## Launch GEM GUI
#GEM_GUI()  # remove the hash symbol for running

## Checking the vignettes for more details
if(interactive()) browseVignettes(package = 'GEM')

}
\author{
Hong Pan
}
\references{
\url{https://github.com/fastGEM/GEM}
}
\seealso{
\code{\link{GEM_GUI}}
}

