% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdcShinyPlot.R
\name{shinyPathview}
\alias{shinyPathview}
\title{Shiny pathview}
\usage{
shinyPathview(gene, pathways, directory = ".")
}
\arguments{
\item{gene}{a vector of numeric values (eg. fold change on log2 scale) 
with names are Ensembl gene ids}

\item{pathways}{a vector of KEGG pathway ids}

\item{directory}{the folder to save pathway figures. 
Default is the working directory}
}
\value{
a local webpage for visualization of KEGG maps
}
\description{
A simple \pkg{shiny} app to show pathways genetrated by 
    \pkg{pathview} package on local web browser
}
\examples{
genes <- c('ENSG00000000938','ENSG00000000971','ENSG00000001036',
        'ENSG00000001084','ENSG00000001167','ENSG00000001460')
pathways <- c("hsa05414~Dilated cardiomyopathy (DCM)",
            "hsa05410~Hypertrophic cardiomyopathy (HCM)",
            "hsa05412~Arrhythmogenic right ventricular cardiomyopathy",
            "hsa04512~ECM-receptor interaction",
            "hsa04510~Focal adhesion",
            "hsa04360~Axon guidance",
            "hsa04270~Vascular smooth muscle contraction",
            "hsa05205~Proteoglycans in cancer",
            "hsa04022~cGMP-PKG signaling pathway",
            "hsa00480~Glutathione metabolism")
\dontrun{shinyPathview(gene=genes, pathways=pathways)}
}
\author{
Ruidong Li and Han Qu
}
