vcf_fn <- system.file("extdata", "sample.vcf", package = "GBScleanR")
gds_fn <- tempfile("sample", fileext = ".gds")
gbsrVCF2GDS(vcf_fn, gds_fn, verbose = FALSE)
on.exit({unlink(gds_fn)})

test_that("estGeno", {
    gds <- loadGDS(gds_fn)
    gds <- setParents(gds, grep("Founder", getSamID(gds), value=TRUE))
    gds <- initScheme(gds, cbind(c(1:2)))
    gds <- addScheme(gds, "self")
    gds <- estGeno(gds)
    p_hap <- getHaplotype(gds, parents = "only")
    expect_true(all(p_hap[,1,] == 1))
    expect_true(all(p_hap[,2,] == 2))
    hap <- getHaplotype(gds)
    expect_true(all(dim(hap) == c(2, nsam(gds), nmar(gds))))
    p_geno <- getGenotype(gds, node = "parents")
    expect_true(nrow(p_geno) == sum(getParents(gds, TRUE)) * 2)
    expect_true(ncol(p_geno) == nmar(gds, FALSE))
    cor_geno <- getGenotype(gds, "cor")
    expect_equal(dim(cor_geno), c(nsam(gds), nmar(gds)))
    closeGDS(gds)
})
