% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{validMar}
\alias{validMar}
\alias{validMar<-}
\alias{validMar,GbsrGenotypeData-method}
\alias{validMar<-,GbsrGenotypeData-method}
\title{Return a logical vector indicating which are valid SNP markers.}
\usage{
validMar(object, chr = NULL, ...)

validMar(object) <- value

\S4method{validMar}{GbsrGenotypeData}(object, chr)

\S4method{validMar}{GbsrGenotypeData}(object) <- value
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{chr}{A index to spefcify chromosome to get information.}

\item{...}{Unused.}

\item{value}{A logical vector indicating valid markers with the length
matching with the number of markers.}
}
\value{
A logical vector of the same length with
the number of total SNP markers
}
\description{
Return a logical vector indicating which are valid SNP markers.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

validMar(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
