% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getChromosome}
\alias{getChromosome}
\alias{getChromosome,GbsrGenotypeData-method}
\title{Obtain chromosome IDs of markers}
\usage{
getChromosome(object, valid = TRUE, ...)

\S4method{getChromosome}{GbsrGenotypeData}(object, valid)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{valid}{A logical value. See details.}

\item{...}{Unused.}
}
\value{
A vector of factors indicating chromosome IDs.
}
\description{
This function returns chromosome IDs of markers.
}
\details{
If \code{valid = TRUE}, the chromosome IDs of the markers which are labeled \code{TRUE}
in the "valid" column of the "marker" slot will be returned. If you need the
number of over all markers, set \code{valid = FALSE}. \code{\link[=validMar]{validMar()}} tells you
which markers are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

getChromosome(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
