% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchReads.R
\name{searchReads}
\alias{searchReads}
\title{searchReads function}
\usage{
searchReads(host, readGroupIds, referenceId = NA_character_,
  start = NA_integer_, end = NA_integer_, nrows = Inf,
  responseSize = NA_integer_)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{readGroupIds}{The ReadGroups to search. At least one id must be
specified.}

\item{referenceId}{The reference to query. Leaving blank returns results from
all references, including unmapped reads - this could be very large.}

\item{start}{The start position (1-based) of this query. If a reference is
specified, this defaults to 0. Genomic positions are non-negative integers
less than reference length. Requests spanning the join of circular genomes
are represented as two requests one on each side of the join (position 1).}

\item{end}{The end position (1-based, exclusive) of this query. If a
reference is specified, this defaults to the reference's length.}

\item{nrows}{Number of rows of the data frame returned by this function.
If not defined, the function will return all entries. If the number of
available entries is less than the value of this this parameter, the function
will silently return only the available entries.}

\item{responseSize}{Specifies the number of entries to be returned by the
server until reach the number of rows defined in \code{nrows} parameter or
until get all available entries. If not defined, the server will return the
allowed maximum reponse size. Increasing this the value of this parameter will
reduce the number of requests and reducing the time required. The will not
respect this parameter if the value if larger than its maximum response size.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Search for reads by genomic range (bases of aligned sequences)
}
\details{
This function requests \code{POST host/reads/search}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
readGroupIds <- "WyIxa2dlbm9tZXMiLCJyZ3MiLCJIRzAzMjcwIiwiRVJSMTgxMzI5Il0"
referenceSetId <- searchReferenceSets(host, nrows = 1)$id
referenceId <- searchReferences(host, referenceSetId, nrows = 1)$id
searchReads(host, readGroupIds, referenceId, start = 15000, end = 16000)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/read_service.proto.html#SearchReads}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}
}
