% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getReadGroupSet.R
\name{getReadGroupSet}
\alias{getReadGroupSet}
\title{getReadGroupSet function}
\usage{
getReadGroupSet(host, readGroupSetId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{readGroupSetId}{The ID of the ReadGroupSet to be retrieved.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get a read group set by its ID.
}
\details{
This function requests \code{GET host/readgroupsets/readGroupSetId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
readGroupSetId <- searchReadGroupSets(host, datasetId, nrows = 1)$id
getReadGroupSet(host, readGroupSetId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/read_service.proto.html#GetReadGroupSet}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchReadGroupSets}}
}
