% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIndividual.R
\name{getIndividual}
\alias{getIndividual}
\title{getIndividual function}
\usage{
getIndividual(host, individualId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{individualId}{ID of the individual requested.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get an individual by its ID.
}
\details{
This function requests \code{GET host/individuals/individualId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
individualId <- searchIndividuals(host, datasetId, nrows = 1)$id
getIndividual(host, individualId)
}
}
\references{
\href{http://ga4gh-schemas.readthedocs.io/en/latest/schemas/bio_metadata_service.proto.html#GetIndividual}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchIndividuals}}
}
