% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G4SNVImpact.R
\name{SNVImpactG4}
\alias{SNVImpactG4}
\title{Evaluate the Impact of SNVs on G4 Sequences}
\usage{
SNVImpactG4(
  G4 = NULL,
  snvs = NULL,
  alt_col = "alt",
  mode = "s",
  sampleid_col = NULL,
  snvid_col = NULL
)
}
\arguments{
\item{G4}{A \code{GRanges} object representing the G4 regions. This object
must include metadata columns for G4 sequence and G4Hunter scores.
It should come from the results returned by the
\code{G4HunterDetect} function.}

\item{snvs}{A \code{GRanges} object representing the SNVs. This object must
include metadata columns for SNV alternative alleles and, optionally,
SNV IDs.}

\item{alt_col}{A character string specifying the name of the column in
\code{snvs} that contains the alternative alleles for the SNVs.
The default is \code{"alt"}.}

\item{mode}{A character string indicating the mode of operation.
Set to \code{"s"} to evaluate the impact of individual SNVs on G4 regions
one at a time.
Set to \code{"m"} to assess the combined impact of multiple SNVs that
overlap the same G4 region within a sample.
If using \code{"m"} mode, you must specify the \code{sampleid_col} and
\code{snvid_col} parameters.}

\item{sampleid_col}{A character string specifying the name of the column in
\code{snvs} that contains the sample IDs.
This parameter is required when \code{mode} is \code{"m"}, and is ignored if
\code{mode} is \code{"s"}.}

\item{snvid_col}{A character string specifying the column name in
\code{snvs} that contains SNV IDs.
Required when \code{mode} is \code{"m"}.
Ignored if \code{mode} is \code{"s"}.}
}
\value{
A \code{GRanges} object depending on the \code{mode} parameter:
\describe{
  \item{Mode "s":}{
    For \code{mode = "s"}, the returned \code{GRanges} object includes the
    following metadata columns:
    \itemize{
      \item \code{seqnames} Identifiers for SNVs.
      \item \code{ranges} Position of the SNVs.
      \item \code{strand} Strand of the SNVs.
      \item \code{SNV.info.*} Metadata columns related to each SNV.
      \item \code{G4.info.*} Metadata columns from the original G4 object.
      \item \code{mut.G4.seq} The mutated G4 sequence after applying the
      SNV change.
      \item \code{mut.G4.anno.seq} The mutated G4 sequence, with the
      mutated bases annotated using square brackets.
      \item \code{mut.score} The G4Hunter score of the mutated sequence.
      \item \code{score.diff} The difference between the mutated G4Hunter
      score and the original G4Hunter score.
      The value is calculated as the absolute value of the mutated G4Hunter
      score minus the absolute value of the original G4Hunter score.
    }
  }
  \item{Mode "m":}{
    For \code{mode = "m"}, the returned \code{GRanges} object includes the
    following metadata columns:
    \itemize{
      \item \code{seqnames} Identifiers for G4 sequences.
      \item \code{ranges} Position of the G4 sequences (start and end).
      \item \code{strand} Strand of the G4 sequences.
      \item \code{G4.info.*} Metadata columns from the original G4 object.
      \item \code{snv.ids} Concatenated SNV IDs for all SNVs affecting the
      G4 region.
      \item \code{sample.ids} A semicolon-separated list of sample IDs
      overlapping each G4 region.
      \item \code{mut.G4.seq} The mutated G4 sequence after applying the
      combined SNV changes.
      \item \code{mut.G4.anno.seq} The mutated G4 sequence, with the
      mutated bases annotated using square brackets.
      \item \code{mut.score} The G4Hunter score of the mutated sequence.
      \item \code{score.diff} The difference between the mutated G4Hunter
      score and the original G4Hunter score. This value is calculated as the
      absolute value of the mutated G4Hunter score minus the absolute value
      of the original G4Hunter score.
    }
  }
}
}
\description{
This function is deprecated and will be removed in a future version.
}
\details{
This function evaluates the impact of SNVs on G4 formation.
}
\section{Deprecated}{

This function is no longer supported.
Use \code{\link{G4VarImpact}} instead.
}

\examples{

if (!requireNamespace("BiocManager", quietly = TRUE)) {
  install.packages("BiocManager")
}

if (!requireNamespace("GenomicRanges", quietly = TRUE)) {
  BiocManager::install("GenomicRanges")
}

if (!requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)) {
  BiocManager::install("BSgenome.Hsapiens.UCSC.hg19")
}

library(GenomicRanges)
library(BSgenome.Hsapiens.UCSC.hg19)

# Load sequence for chromosome 21 (hg19)
hg19 <- BSgenome.Hsapiens.UCSC.hg19
chr21_seq <- DNAStringSet(hg19$chr21)
# Chromosome name is needed
names(chr21_seq) <- "chr21"

# Detect G4s in human chromosome 21
G4 <- G4HunterDetect(chr21_seq)

# 's' mode
# Load SNPs
data(snp_gr)

# Obtain SNPs that overlap with G4 regions and assess their impact on G4.
# In variant-centric mode ('s'), evaluating each SNP individually.
res_snp <- SNVImpactG4(G4, snp_gr, alt_col = "alt")
print(res_snp)

# 'm' mode
# Load SNVs
data(snv_gr)

# Obtain SNVs that overlap with G4 regions and assess their impact on G4.
# In sample-centric mode ('m'), evaluate the combined impact of SNVs on G4s.
# Grouped by the sample IDs specified in 'sampleid_col'.
res_snv <- SNVImpactG4(G4, snv_gr,
  alt_col = "alt",
  mode = "m", sampleid_col = "sampleid", snvid_col = "snv_id"
)
print(res_snv)
}
\seealso{
\code{\link{G4HunterDetect}} for detecting the G4 sequences in a
               given \code{DNAStringSet} object.
         \code{\link{G4HunterScore}} for calculating the G4Hunter scores
               for a given sequence.
         \code{\link{filterSNVImpact}} for filtering out SNVs with
               significant impact.
}
