% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreFunctions.R
\name{computeGridSize}
\alias{computeGridSize}
\title{Estimate the optimal grid size}
\usage{
computeGridSize(dataset)
}
\arguments{
\item{dataset}{The optimal grid size.}
}
\value{
the optimal grid size.
}
\description{
The function finds the eigenvalues of the sample covariance matrix.
It will then return the number of significant eigenvalues according to
the Tracy-Widom test.
The function is based on the estKW function from the SC3 package
}
\examples{
data("risom_dat")
risomMarkers <- c(
  "CD45", "SMA", "CK7", "CK5", "VIM", "CD31", "PanKRT", "ECAD"
)
computeGridSize(risom_dat[, risomMarkers])

}
\author{
Elijah WIllie \href{mailto:ewil3501@uni.sydney.edu.au}{ewil3501@uni.sydney.edu.au}
}
