% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_readInput.R
\name{ReadInput}
\alias{ReadInput}
\title{Read FCS-files or flowFrames}
\usage{
ReadInput(
  input,
  pattern = ".fcs",
  compensate = FALSE,
  spillover = NULL,
  transform = FALSE,
  toTransform = NULL,
  transformFunction = flowCore::logicleTransform(),
  transformList = NULL,
  scale = FALSE,
  scaled.center = TRUE,
  scaled.scale = TRUE,
  silent = FALSE
)
}
\arguments{
\item{input}{a flowFrame, a flowSet, a matrix with column names or
an array of paths to files or directories}

\item{pattern}{if input is an array of file- or directorynames, 
select only files containing pattern}

\item{compensate}{logical, does the data need to be compensated}

\item{spillover}{spillover matrix to compensate with
If \code{NULL} and compensate = \code{TRUE}, we will
look for \code{$SPILL} description in FCS file.}

\item{transform}{logical, does the data need to be transformed}

\item{toTransform}{column names or indices that need to be transformed.
Will be ignored if \code{transformList} is given.
If \code{NULL} and transform = \code{TRUE}, column names
of \code{$SPILL} description in FCS file will be used.}

\item{transformFunction}{Defaults to logicleTransform()}

\item{transformList}{transformList to apply on the samples.}

\item{scale}{logical, does the data needs to be rescaled}

\item{scaled.center}{see \code{\link{scale}}}

\item{scaled.scale}{see \code{\link{scale}}}

\item{silent}{if \code{TRUE}, no progress updates will be printed. 
Default = \code{FALSE}}
}
\value{
FlowSOM object containing the data, which can be used as input
for the BuildSOM function
}
\description{
Take some input and return FlowSOM object containing a matrix with 
the preprocessed data (compensated, transformed, scaled)
}
\examples{
# Read from file
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
flowSOM.res <- ReadInput(fileName, compensate = TRUE, transform = TRUE,
                         scale = TRUE)

# Or read from flowFrame object
ff <- flowCore::read.FCS(fileName)
ff <- flowCore::compensate(ff, flowCore::keyword(ff)[["SPILL"]])
ff <- flowCore::transform(ff,
         flowCore::transformList(colnames(flowCore::keyword(ff)[["SPILL"]]),
                                flowCore::logicleTransform()))
flowSOM.res <- ReadInput(ff, scale = TRUE)

# Build the self-organizing map and the minimal spanning tree
flowSOM.res <- BuildSOM(flowSOM.res, colsToUse = c(9, 12, 14:18))
flowSOM.res <- BuildMST(flowSOM.res)

# Apply metaclustering
metacl <- MetaClustering(flowSOM.res$map$codes,
                         "metaClustering_consensus", max = 10)

# Get metaclustering per cell
flowSOM.clustering <- metacl[flowSOM.res$map$mapping[, 1]]    
 
}
\seealso{
\code{\link{scale}}, \code{\link{BuildSOM}}
}
