% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{PlotMarker}
\alias{PlotMarker}
\title{PlotMarker}
\usage{
PlotMarker(
  fsom,
  marker,
  refMarkers = fsom$map$colsUsed,
  title = GetMarkers(fsom, marker),
  colorPalette = FlowSOM_colors,
  lim = NULL,
  ...
)
}
\arguments{
\item{fsom}{FlowSOM object}

\item{marker}{A vector of markers/channels to plot.}

\item{refMarkers}{Is used to determine relative scale of the marker 
that will be plotted. Default are all markers used in the
clustering.}

\item{title}{A vector with custom titles for the plot. Default is 
the marker name.}

\item{colorPalette}{Color palette to use. Can be a function or a vector.}

\item{lim}{Limits for the scale}

\item{...}{Additional arguments to pass to \code{\link{PlotFlowSOM}},
e.g. view, backgroundValues, equalNodeSize ...}
}
\value{
A ggplot figure is returned in which every cluster is colored
        according to the MFI value for the specified marker
}
\description{
Plot comparison with other clustering
}
\details{
Plot FlowSOM grid or tree, colored by node values for a specific marker
}
\examples{
# Build FlowSOM model
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
flowSOM.res <- FlowSOM(fileName, 
                       compensate = TRUE, transform = TRUE, scale = FALSE,
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)
# Plot one marker
PlotMarker(flowSOM.res, 
           "CD19")
           
PlotMarker(flowSOM.res, 
           "CD19",
           colorPalette = c("gray", "red"))
           
# Plot all markers
PlotMarker(flowSOM.res,
           c(9, 12, 14:18))

# Use specific limits if the ones from the columns used for clustering
# are not relevant for  your marker of choice
PlotMarker(flowSOM.res, 
           "FSC-A",
            lim = c(55000, 130000))

# Example with additional FlowSOM plotting options
PlotMarker(flowSOM.res, 
           "CD19",
           view = "grid",
           equalNodeSize = TRUE,
           backgroundValues = 1:100 == 27,
           backgroundColors = c("white", "red"))
           
           
}
\seealso{
\code{\link{PlotStars}}, \code{\link{PlotVariable}}
}
