% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{PlotLabels}
\alias{PlotLabels}
\title{PlotLabels}
\usage{
PlotLabels(
  fsom,
  labels,
  maxNodeSize = 0,
  textSize = 3.88,
  textColor = "black",
  ...
)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{FlowSOM}}}

\item{labels}{A vector of labels for every node.}

\item{maxNodeSize}{Determines the maximum node size. Default is 0.}

\item{textSize}{Size for geom_text. Default (=3.88) is from geom_text.}

\item{textColor}{Color for geom_text. Default = black.}

\item{...}{Additional arguments to pass to \code{\link{PlotFlowSOM}}}
}
\value{
Nothing is returned. A plot is drawn in which each node is 
represented by a label.
}
\description{
Plot labels for each cluster
}
\details{
Plot FlowSOM grid or tree, with in each node a label. 
Especially useful to show metacluster numbers
}
\examples{
# Read from file, build self-organizing map and minimal spanning tree
fileName <- system.file("extdata", "68983.fcs", package="FlowSOM")
ff <- flowCore::read.FCS(fileName)
ff <- flowCore::compensate(ff, flowCore::keyword(ff)[["SPILL"]])
ff <- flowCore::transform(ff,
         flowCore::transformList(colnames(flowCore::keyword(ff)[["SPILL"]]),
                                flowCore::logicleTransform()))
flowSOM.res <- FlowSOM(ff,
                       scale = TRUE,
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)

# Plot the node IDs
PlotLabels( flowSOM.res, 
            flowSOM.res$metaclustering)

}
\seealso{
\code{\link{PlotStars}}, \code{\link{PlotVariable}},
\code{\link{PlotFlowSOM}}, \code{\link{PlotMarker}}, 
\code{\link{PlotNumbers}}, \code{\link{PlotPies}}, 
\code{\link{QueryStarPlot}}, \code{\link{PlotSD}}
}
