% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_FlowSOM.R
\name{GetMarkers}
\alias{GetMarkers}
\title{GetMarkers}
\usage{
GetMarkers(object, channels, exact = TRUE)
}
\arguments{
\item{object}{The flowFrame or the FlowSOM object of interest}

\item{channels}{Vector with markers or channels of interest. Also accepts the
index of the channel in the object.}

\item{exact}{If TRUE (default), the grep pattern will be extended to
start with ^\\\\Q and end with \\\\E$, so only exact matches 
are possible.}
}
\value{
Corresponding marker names
}
\description{
Get marker names for an array of channels, given a flowFrame or a FlowSOM 
object. As available in "desc". If this is NA, defaults to channel name. 
\code{\link{grep}} is used to look for the markers. Other regex can be added.
}
\examples{

   # Read the flowFrame
   fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
   ff <- flowCore::read.FCS(fileName)
   GetChannels(ff, c("FSC-A", "CD3", "FITC-A"))
   GetMarkers(ff, c("FSC-A", "CD3", "FITC-A"))

}
\seealso{
\code{\link{GetChannels}}
}
