% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_deprecated.R
\name{CountGroups}
\alias{CountGroups}
\title{Calculate differences in cell counts between groups}
\usage{
CountGroups(fsom, groups, plot = TRUE, silent = FALSE)
}
\arguments{
\item{fsom}{FlowSOM object as generated by BuildSOM}

\item{groups}{List containing an array with file names for each group}

\item{plot}{Logical. If TRUE, make a starplot of each individual file}

\item{silent}{Logical. If TRUE, print progress messages}
}
\value{
Distance matrix
}
\description{
Calculate differences in cell counts between groups
}
\examples{
set.seed(1)
fileName <-  system.file("extdata", "68983.fcs", package="FlowSOM")
flowSOM.res <- FlowSOM(fileName, compensate = TRUE, transform = TRUE,
                      scale = TRUE, colsToUse = c(9,12,14:18), nClus = 10)

ff <- flowCore::read.FCS(fileName)
# Make an additional file without cluster 7 and double amount of cluster 5
selection <- c(which(GetClusters(flowSOM.res) \%in\% 
                                 which(flowSOM.res$metaclustering != 7)),
                 which(GetClusters(flowSOM.res) \%in\% 
                                 which(flowSOM.res$metaclustering == 5)))
ff_tmp <- ff[selection,]
flowCore::write.FCS(ff_tmp, file="ff_tmp.fcs")

# Compare only the file with the double amount of cluster 10
features <- GetFeatures(flowSOM.res, 
                        c(fileName, "ff_tmp.fcs"),
                        level = "clusters",
                        type = "percentages")
stats <- GroupStats(features$cluster_percentages,                     
                    groups = list("AllCells" = c(fileName),
                                  "Without_ydTcells" = c("ff_tmp.fcs")))

}
\seealso{
GroupStats
}
