% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakGeneCor.R
\name{peakGeneCor}
\alias{peakGeneCor}
\title{peakGeneCor}
\usage{
peakGeneCor(mmAnno, peakScoreMt, geneScoreMt, parallel = FALSE, verbose = TRUE)
}
\arguments{
\item{mmAnno}{the annotated GRange object from mm_geneScan or mm_nearestGene}

\item{peakScoreMt}{peak count matrix. The rownames are feature_id in mmAnno,
while the colnames are sample names.}

\item{geneScoreMt}{gene count matirx. The rownames are gene_id in mmAnno,
while the colnames are sample names.}

\item{parallel}{whehter you want to using bplapply to speed up calculation}

\item{verbose}{whether you want to report detailed running message}
}
\value{
mmAnno with Cor, pvalue,padj,qvalue column
}
\description{
peakGeneCor
}
\examples{

if (require(TxDb.Athaliana.BioMart.plantsmart28)){
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))
    data("RNA_normCount")
    data("ATAC_normCount")
    peak_path <- system.file("extdata", "ATAC.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)[1:100]
    mmAnno <- mm_geneScan(peak_GR, Txdb)

    ATAC_colData <- data.frame(
        row.names = colnames(ATAC_normCount),
        type = gsub("_R[0-9]", "", colnames(ATAC_normCount))
    )

    ATAC_normCount_merge <- integrate_replicates(ATAC_normCount, ATAC_colData)
    RNA_colData <- data.frame(
        row.names = colnames(RNA_normCount),
        type = gsub("_R[0-9]", "", colnames(RNA_normCount))
    )
    RNA_normCount_merge <- integrate_replicates(RNA_normCount, RNA_colData)
    mmAnnoCor <- peakGeneCor(
        mmAnno = mmAnno,
        peakScoreMt = ATAC_normCount_merge,
        geneScoreMt = RNA_normCount_merge,
        parallel = FALSE
    )

    mmAnnoCor

}
}
