% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmPeakAnno.R
\name{mm_geneScan}
\alias{mm_geneScan}
\title{mm_geneScan}
\usage{
mm_geneScan(
  peak_GR,
  Txdb,
  upstream = 3000,
  downstream = 3000,
  reportGeneInfo = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{peak_GR}{peak GRange with a column named feature_id representing you peak name}

\item{Txdb}{Txdb}

\item{upstream}{distance to start site(upstream)}

\item{downstream}{distance to start site(downstream)}

\item{reportGeneInfo}{whether you want to add gene info}

\item{verbose}{whether you want to report detailed running message}

\item{...}{additional arguments in findOverlaps}
}
\value{
Granges object with annotated info
}
\description{
Annotate peaks using geneScan mode, which means every peak have more than one
related genes.
}
\examples{
if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))
    peak_path <- system.file("extdata", "ChIP.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)
    peakAnno <- mm_geneScan(peak_GR, Txdb)
    peakAnno
}
}
