% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simData}
\alias{simData}
\title{simData}
\usage{
simData(conditions, n_latent_factors, replicates)
}
\arguments{
\item{conditions}{number of conditions to generate samples from}

\item{n_latent_factors}{number of latent factors to generate}

\item{replicates}{number of replicates to generate}
}
\value{
\code{SummarizedExperiment} object carrying simulated data, with 
\code{colData} indicating which sample belongs to which replicate
}
\description{
simulate Data with orthogonal feature clusters and replicated
samples. Each feature cluster corresponds to a different latent factor and
contains 10 redundant features. E.g. choosing samples = 100,
n_latent_factors = 5 and replicates = 2
will simulate a 50 x 200 data matrix, where the first 100 samples belong to
replicate 1 and sample 101-200 belong to replicate 2.
\cr
\cr
}
\details{
simData constructs n_latent_factors by generating a random matrix
\eqn{\mathbf{Q}} whose row vectors
\eqn{\mathbf{Q}_{i\cdot}  \sim \mathcal{N}(0,1)}
with \eqn{n} samples and \eqn{i \in \{1, \dots, 
\textrm{n\_latent\_factors}\}} are
orthonormal, each corresponding to a different latent factor. To simulate a
set of redundant feature groups, it generates 10 features \eqn{X_{j\cdot}}
for each latent factor \eqn{\mathbf{Q}_{i\cdot}} by scaling each latent
factor by a random factor \eqn{\delta_j \sim \mathcal{N}(0,1)} and adding
replicate specific noise
\eqn{\pmb{\epsilon}_c \sim \mathcal{N}(0,0.1)} with
\eqn{c \in \{1, \dots, \textrm{replicates}\}} preserving orthogonality.
}
\examples{
# simulate data 100 samples from 100 conditions, 20 features generated by 2 
# latent factors and 2 replicates
simData(conditions=100, n_latent_factors=2, replicates=2)
}
