% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeExternalData.R
\name{mergeExternalData}
\alias{mergeExternalData}
\title{Merge external data}
\usage{
mergeExternalData(fds, countFiles, sampleIDs, annotation = NULL)
}
\arguments{
\item{fds}{A \code{FraserDataSet}}

\item{countFiles}{A character vector of file names pointing to the external 
count data. The vector has to be names or the files have to start 
with \code{k_j}, \code{k_theta}, \code{n_psi3}, \code{n_psi5}, 
\code{n_theta}.}

\item{sampleIDs}{The samples to be merged from the external data.}

\item{annotation}{A sample annotation of the external data (optional).}
}
\value{
Merged \code{FraserDataSet} object.
}
\description{
To boost its own sequencing data, one can download existing and precounted 
data. This function merges the existing \code{FraserDataSet} with
external count data.
}
\details{
For more details on existing datasets have a look at:
<https://github.com/gagneurlab/drop#datasets>

Since FRASER can not hand NA values, the merge will return only the 
intersecting regions and will drop any non overlapping features. This has to
be kept in mind when analysing rare disease samples.
}
\examples{
anno <- data.table::fread(system.file("extdata", "externalCounts",
        "annotation.tsv.gz", package="FRASER"))
ctsFiles <- list.files(full.names = TRUE, pattern="counts",
        system.file("extdata", "externalCounts", package="FRASER"))

fds <- createTestFraserDataSet()
fds_merged <- mergeExternalData(fds, ctsFiles, anno[,sampleID], anno)

K(fds, "psi5")
K(fds_merged, "psi5")

}
