% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildGraphFromKEGGREST.R
\name{infere.con2ec}
\alias{infere.con2ec}
\title{Infer connections to EC}
\usage{
infere.con2ec(ids, ent, ent2gene, gene2enzyme)
}
\arguments{
\item{ids}{Character vector of identifiers to map. For example, 
all the KEGG pathways}

\item{ent}{Character, entity that we are mapping 
(one of \code{"pathway"} and one of \code{"module"})}

\item{ent2gene}{Named character vector, names are the entity \code{ent} 
and values are genes}

\item{gene2enyzme}{Named character vector, names are genes and 
values are EC enzyme families
category Character, one of:}
}
\value{
Two-column data frame. Column \code{"from"} contains the 
KEGG enzyme families whereas \code{"to"} contains the entity \code{ent}.
}
\description{
Function \code{infere.con2ec} infers network connections to KEGG EC 
families by passing through genes. This assumes that the category being 
mapped to enzymes is above them.
}
\examples{
ids <- "hsa00010"
ent <- "pathway"
ent2gene <- c("hsa00010" = "hsa:10", "hsa00010" = "hsa:120")
gene2enzyme <- c("hsa:10" = "1.1.1.1", "hsa:120" = "1.2.3.4")
FELLA:::infere.con2ec(ids, ent, ent2gene, gene2enzyme)

}
\keyword{internal}
