% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-.R
\name{getMatrix}
\alias{getMatrix}
\title{Get matrix for the desired methodology}
\usage{
getMatrix(data, method)
}
\arguments{
\item{data}{FELLA.DATA object}

\item{method}{Character, exactly one of: 
\code{"hypergeom"}, \code{"diffusion"}, \code{"pagerank"}}
}
\value{
Matrix for the desired methodology (internal usage)
}
\description{
Extractor function for the matrices of 
hypergeometric, diffusion and PageRank methodologies
}
\examples{
## This function is internal
attach(environment(FELLA:::getMatrix))
data(FELLA.sample)
# When a matrix is loaded:
x <- getMatrix(FELLA.sample, "hypergeom")
dim(x)
# When it is not:
y <- getMatrix(FELLA.sample, "diffusion")
dim(y)
y
}
