% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{subsetSummary}
\alias{subsetSummary}
\alias{subsetSummary,SubsetRangedSummarizedExperiment-method}
\alias{subsetSummary,SubsetSingleCellExperiment-method}
\alias{subsetSummary,SubsetSummarizedExperiment-method}
\alias{subsetSummary,SubsetSpatialExperiment-method}
\alias{subsetSummary,SubsetTreeSummarizedExperiment-method}
\title{Method for displaying 'child-parent' link structure of subsets in
  ExperimentSubset objects}
\usage{
subsetSummary(x)

\S4method{subsetSummary}{SubsetRangedSummarizedExperiment}(x)

\S4method{subsetSummary}{SubsetSingleCellExperiment}(x)

\S4method{subsetSummary}{SubsetSummarizedExperiment}(x)

\S4method{subsetSummary}{SubsetSpatialExperiment}(x)

\S4method{subsetSummary}{SubsetTreeSummarizedExperiment}(x)
}
\arguments{
\item{x}{\code{ExperimentSubset} Input \code{ExperimentSubset} object.}
}
\value{
Prints all the available subset information against the input
  \code{ExperimentSubset} object.
}
\description{
The function displays the content of an \code{ExperimentSubset}
  object including all available main assays, all subsets and the subset
  assays inside these subsets. This function also depicts how and in what
  order the subsets in the object are linked with their parents. Moreover,
  all supplementary data inside the subsets such as \code{reducedDims} and
  \code{altExps} are also displayed against each subset entry.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
assay(es, "subset1",
subsetAssayName = "subset1pAssay") <- assay(es, "subset1")[,] + 1
subsetSummary(es)
}
