% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-methods.R
\name{select}
\alias{select}
\alias{columns}
\alias{keys}
\alias{keytypes}
\alias{select,EpiTxDb-method}
\alias{columns,EpiTxDb-method}
\alias{keys,EpiTxDb-method}
\alias{keytypes,EpiTxDb-method}
\title{Using the "select" interface on \code{EpiTxDb} objects}
\usage{
\S4method{select}{EpiTxDb}(x, keys, columns, keytype, ...)

\S4method{columns}{EpiTxDb}(x)

\S4method{keys}{EpiTxDb}(x, keytype, ...)

\S4method{keytypes}{EpiTxDb}(x)
}
\arguments{
\item{x}{a \code{\link[=EpiTxDb-class]{EpiTxDb}} object}

\item{keys, columns, keytype, ...}{See
\code{\link[AnnotationDbi:AnnotationDb-class]{AnnotationDb}} for more
comprehensive description of the methods \code{select}, \code{keys},
\code{columns} and \code{keytypes} and their arguments.}
}
\value{
a \code{data.frame} object for \code{select()} and a \code{character}
  vecor for \code{keytypes()}, \code{keys()} and \code{columns()}.
}
\description{
As expected for a \code{AnnotationDb} object, the general accessors
  \code{select}, \code{keys}, \code{columns} and \code{keytypes} can be used
  to get information from a \code{\link[=EpiTxDb-class]{EpiTxDb}} object.
}
\examples{
etdb_file <- system.file("extdata", "EpiTxDb.Hs.hg38.snoRNAdb.sqlite",
                         package="EpiTxDb")
etdb <- loadDb(etdb_file)
etdb
}
